/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.InputException;
import org.tp23.antinstaller.input.ValidatedTextInput;
import org.tp23.antinstaller.input.Validator;

public class ExtValidatedTextInput
extends ValidatedTextInput {
    private String validationClass;
    private Validator validator;
    private Throwable throwable;

    public void setValue(String dir) {
        this.setInputResult(dir);
    }

    public String getValidationClass() {
        return this.validationClass;
    }

    public void setValidationClass(String validationClass) {
        this.validationClass = validationClass;
        try {
            this.validator = (Validator)Class.forName(validationClass).newInstance();
        }
        catch (Exception ex) {
            throw new InputException("Invalid Class in ExtValidated text input");
        }
    }

    public boolean validate(InstallerContext ctx) throws ValidationException {
        String result = this.getInputResult();
        try {
            this.validator.validate(result, ctx);
            this.throwable = null;
            return true;
        }
        catch (Throwable t) {
            this.throwable = t;
            return false;
        }
    }

    public Validator getValidator() {
        return this.validator;
    }

    public boolean validateObject() {
        if (this.getDisplayText() == null) {
            System.out.println("ExtValidated:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            System.out.println("ExtValidated:property must be set");
            return false;
        }
        if (this.getValidationClass() == null) {
            System.out.println("ExtValidated:validationClass must be set");
            return false;
        }
        return true;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

