/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.jgoodies.plaf.plastic;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLabelUI;
import org.tp23.jgoodies.clearlook.ClearLookManager;
import org.tp23.jgoodies.clearlook.ClearLookUtils;
import org.tp23.jgoodies.plaf.plastic.PlasticXPLookAndFeel;

public final class PlasticLabelUI
extends MetalLabelUI {
    private static final PlasticLabelUI INSTANCE = new PlasticLabelUI();

    public static ComponentUI createUI(JComponent x) {
        return INSTANCE;
    }

    public void paint(Graphics g, JComponent c) {
        JLabel label = (JLabel)c;
        if (!ClearLookUtils.hasCheckedBorder(label)) {
            Border oldBorder = ClearLookManager.replaceBorder(label);
            ClearLookUtils.storeBorder(label, oldBorder);
        }
        Graphics2D g2 = (Graphics2D)g;
        if (PlasticXPLookAndFeel.isAntiAliased()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        super.paint(g, c);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void uninstallDefaults(JLabel label) {
        Border storedBorder = ClearLookUtils.getStoredBorder(label);
        if (storedBorder != null) {
            label.setBorder(storedBorder);
        }
        super.uninstallDefaults(label);
    }
}

