/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.InputException;
import org.tp23.antinstaller.input.InputField;

public class DateInput
extends InputField {
    private String dateFormat = "dd/MM/yyyy";
    private DateFormat formatter = new SimpleDateFormat(this.dateFormat);

    public DateInput() {
        this.formatter.setLenient(false);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        try {
            this.formatter = new SimpleDateFormat(dateFormat);
            this.formatter.setLenient(false);
            this.dateFormat = dateFormat;
        }
        catch (RuntimeException e) {
            throw new InputException("Invalid date format in DateInput");
        }
    }

    public void setValue(String dir) {
        this.setInputResult(dir);
    }

    public boolean validate(InstallerContext cxt) throws ValidationException {
        if (this.getInputResult() == null) {
            return false;
        }
        String toTest = this.getInputResult();
        try {
            this.formatter.parse(toTest);
        }
        catch (ParseException ex) {
            return false;
        }
        return true;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue.equals("TODAY") ? this.formatter.format(new Date()) : defaultValue;
    }

    public boolean validateObject() {
        if (this.getDisplayText() == null) {
            System.out.println("Date:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            System.out.println("Date:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            System.out.println("Date:defaultValue must be set");
            return false;
        }
        return true;
    }
}

