/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.tp23.antinstaller.InstallerContext;

public class ResultContainer {
    private HashMap properties = new HashMap();
    private Properties environment = InstallerContext.getEnvironment();
    private File installRoot;

    public String getDefaultFileRef(String defaultString) {
        if (defaultString == null) {
            return null;
        }
        String expandedRefs = this.getDefaultValue(defaultString);
        File ref = new File(expandedRefs);
        if (!ref.isAbsolute()) {
            String path = null;
            try {
                path = new File(this.installRoot, expandedRefs).getCanonicalPath();
            }
            catch (IOException ex) {
                path = new File(this.installRoot, expandedRefs).getAbsolutePath();
            }
            return path;
        }
        String path = ref.getAbsolutePath();
        return path;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getDefaultValue(String defaultString) {
        if (defaultString == null) {
            return null;
        }
        char[] characters = defaultString.toCharArray();
        StringBuffer result = new StringBuffer();
        StringBuffer propertyNameBuffer = new StringBuffer();
        boolean inProp = false;
        int i = 0;
        while (i < characters.length) {
            char c;
            block14: {
                c = characters[i];
                if (c == '$' && characters.length > i + 1 && characters[i + 1] == '{') {
                    if (inProp) {
                        int endIndex = defaultString.indexOf(125, i + 1);
                        if (endIndex != -1) {
                            propertyNameBuffer.append(this.getDefaultValue(defaultString.substring(i, ++endIndex)));
                            i = endIndex;
                            continue;
                        }
                        result.append(propertyNameBuffer.toString());
                        propertyNameBuffer = new StringBuffer();
                        break block14;
                    } else {
                        inProp = true;
                        propertyNameBuffer.append(c);
                        ++i;
                        continue;
                    }
                }
                if (c == '{') {
                    if (inProp) {
                        propertyNameBuffer.append(c);
                        if (characters[i - 1] != '$') {
                            inProp = false;
                            result.append(propertyNameBuffer.toString());
                            propertyNameBuffer = new StringBuffer();
                        }
                        ++i;
                        continue;
                    }
                } else if (c == '}' && inProp) {
                    this.appendProperty(propertyNameBuffer, result);
                    propertyNameBuffer = new StringBuffer();
                    inProp = false;
                    ++i;
                    continue;
                }
            }
            if (!inProp) {
                result.append(c);
            } else {
                propertyNameBuffer.append(c);
            }
            ++i;
        }
        if (propertyNameBuffer.length() != 0) {
            result.append(propertyNameBuffer.toString());
        }
        return result.toString();
    }

    public HashMap getResults() {
        return this.properties;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    public void setInstallRoot(File installRoot) {
        this.installRoot = installRoot;
    }

    public Map getAllProperties() {
        return this.properties;
    }

    private void appendProperty(StringBuffer propertyNameBuffer, StringBuffer result) {
        String propertyName = propertyNameBuffer.toString();
        String key = propertyName.substring(2);
        String value = (String)this.properties.get(key);
        if (value == null && key.startsWith("env.")) {
            value = this.environment.getProperty(key);
        }
        if (value == null && key.startsWith("java.")) {
            value = this.environment.getProperty(key);
        }
        if (value != null) {
            result.append(value);
        }
    }
}

