/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.util.ArrayList;
import javax.swing.JPanel;
import org.tp23.antinstaller.ResourceBundleHelper;
import org.tp23.antinstaller.input.ConditionalField;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.logic.Expression;
import org.tp23.gui.GBCF;

public class ConditionalFieldRenderer
extends SwingOutputFieldRenderer {
    private ResourceBundleHelper resHelper = new ResourceBundleHelper("org.tp23.antinstaller.renderer.Res");
    private ConditionalField condField;
    private ArrayList renderers = new ArrayList();

    public void initComponent(JPanel parent) {
        this.condField = (ConditionalField)this.outputField;
        InputField[] fields = this.condField.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                SwingOutputFieldRenderer renderer = RendererFactory.getSwingRenderer(fields[i]);
                renderer.setOutputField(fields[i]);
                renderer.setInstallerContext(this.ctx);
                this.renderers.add(renderer);
                continue;
            }
            catch (ClassNotFoundException clsNotFndExc) {
                // empty catch block
            }
        }
    }

    public void updateInputField() {
        if (this.expressionIsTrue()) {
            int listSize = this.renderers.size();
            for (int i = 0; i < listSize; ++i) {
                SwingOutputFieldRenderer renderer = (SwingOutputFieldRenderer)this.renderers.get(i);
                renderer.updateInputField();
            }
        }
    }

    public void updateDefaultValue() {
        if (this.expressionIsTrue()) {
            int listSize = this.renderers.size();
            for (int i = 0; i < listSize; ++i) {
                SwingOutputFieldRenderer renderer = (SwingOutputFieldRenderer)this.renderers.get(i);
                renderer.updateDefaultValue();
            }
        }
    }

    public void renderError() {
        int listSize = this.renderers.size();
        for (int i = 0; i < listSize; ++i) {
            SwingOutputFieldRenderer renderer = (SwingOutputFieldRenderer)this.renderers.get(i);
            renderer.renderError();
        }
    }

    public int addSelf(JPanel content, GBCF cf, int row, boolean overflow) {
        return row;
    }

    private boolean expressionIsTrue() {
        Expression expr = null;
        try {
            expr = this.condField.getExpression();
        }
        catch (ConfigurationException configExc) {
            this.ctx.log(this.resHelper.getMessage("invalid.conditional.expression", configExc));
            return false;
        }
        return expr.evaluate();
    }
}

