/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class TimestampSelector
extends Task {
    private static final String AGE_ELDEST = "eldest";
    private static final String AGE_YOUNGEST = "youngest";
    private String property;
    private Path path;
    private String outputSetId;
    private int count = 1;
    private char pathSep = (char)44;
    private String age = "youngest";

    public void doFileSetExecute(String[] paths) throws BuildException {
    }

    public void sort(Vector array) {
        this.sort(array, 0, array.size() - 1);
    }

    protected void sort(Vector array, int start, int end) {
        if (end > start) {
            int p = this.partition(array, start, end);
            this.sort(array, start, p - 1);
            this.sort(array, p + 1, end);
        }
    }

    protected int compare(File a, File b) {
        if (this.age.equalsIgnoreCase(AGE_ELDEST)) {
            return new Long(a.lastModified()).compareTo(new Long(b.lastModified()));
        }
        return new Long(b.lastModified()).compareTo(new Long(a.lastModified()));
    }

    protected int partition(Vector array, int start, int end) {
        File partitionElement = (File)array.elementAt(end);
        int left = start - 1;
        int right = end;
        while (true) {
            if (this.compare(partitionElement, (File)array.elementAt(++left)) == 1 && left != end) {
                continue;
            }
            while (this.compare(partitionElement, (File)array.elementAt(--right)) == -1 && right != start) {
            }
            if (left >= right) break;
            this.swap(array, left, right);
        }
        this.swap(array, left, end);
        return left;
    }

    protected void swap(Vector array, int i, int j) {
        Object temp = array.elementAt(i);
        array.setElementAt(array.elementAt(j), i);
        array.setElementAt(temp, j);
    }

    public void execute() throws BuildException {
        if (this.property == null && this.outputSetId == null) {
            throw new BuildException("Property or OutputSetId must be specified.");
        }
        if (this.path == null) {
            throw new BuildException("A path element or pathref attribute must be specified.");
        }
        String[] s = this.path.list();
        Vector<File> v = new Vector<File>();
        for (int i = 0; i < s.length; ++i) {
            File f = new File(s[i]);
            if (!f.exists()) continue;
            v.addElement(f);
        }
        this.sort(v);
        Vector v2 = new Vector();
        int sz = v.size();
        for (int i = 0; i < sz && i < this.count; ++i) {
            v2.add(v.elementAt(i));
        }
        Path path = new Path(this.getProject());
        sz = v2.size();
        for (int i = 0; i < sz; ++i) {
            File f = (File)v.elementAt(i);
            Path p = new Path(this.getProject(), f.getAbsolutePath());
            path.addExisting(p);
        }
        if (this.outputSetId != null) {
            this.project.addReference(this.outputSetId, path);
        } else {
            String[] paths = path.list();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < paths.length; ++i) {
                if (i != 0) {
                    sb.append(this.pathSep);
                }
                sb.append(paths[i]);
            }
            if (paths.length != 0) {
                this.project.setProperty(this.property, sb.toString());
            }
        }
    }

    public void setProperty(String property) {
        if (this.outputSetId != null) {
            throw new BuildException("Cannot set both Property and OutputSetId.");
        }
        this.property = property;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setAge(String age) {
        if (!age.equalsIgnoreCase(AGE_ELDEST) && !age.equalsIgnoreCase(AGE_YOUNGEST)) {
            throw new BuildException("Invalid age: " + age);
        }
        this.age = age;
    }

    public void setPathSep(char pathSep) {
        this.pathSep = pathSep;
    }

    public void setOutputSetId(String outputSetId) {
        if (this.property != null) {
            throw new BuildException("Cannot set both Property and OutputSetId.");
        }
        this.outputSetId = outputSetId;
    }

    public void setPathRef(Reference ref) throws BuildException {
        if (this.path != null) {
            throw new BuildException("Path element already specified.");
        }
        this.path = new Path(this.getProject());
        this.path.setRefid(ref);
    }

    public Path createPath() throws BuildException {
        if (this.path != null) {
            throw new BuildException("Path element already specified.");
        }
        this.path = new Path(this.getProject());
        return this.path;
    }
}

