/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.design;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.antcontrib.design.Design;
import net.sf.antcontrib.design.DesignFileHandler;
import net.sf.antcontrib.design.Log;
import net.sf.antcontrib.design.VisitorImpl;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.JAXPUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class VerifyDesignDelegate
implements Log {
    private File designFile;
    private File jarFile;
    private boolean isCircularDesign = false;
    private Task task;
    private Design design;
    private HashSet primitives = new HashSet();
    private String className = "";

    public VerifyDesignDelegate(Task task) {
        this.task = task;
        this.primitives.add("B");
        this.primitives.add("C");
        this.primitives.add("D");
        this.primitives.add("F");
        this.primitives.add("I");
        this.primitives.add("J");
        this.primitives.add("S");
        this.primitives.add("Z");
    }

    public void setJar(File f) {
        this.jarFile = f;
    }

    public void setDesign(File f) {
        this.designFile = f;
    }

    public void setCircularDesign(boolean isCircularDesign) {
        this.isCircularDesign = isCircularDesign;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (!this.designFile.exists()) throw new BuildException("design attribute in verifydesign element specified an invalid file=" + this.designFile);
        if (this.designFile.isDirectory()) {
            throw new BuildException("design attribute in verifydesign element specified an invalid file=" + this.designFile);
        }
        ZipFile jar = null;
        try {
            try {
                XMLReader reader = JAXPUtils.getXMLReader();
                DesignFileHandler ch = new DesignFileHandler(this, this.designFile, this.isCircularDesign, this.task.getLocation());
                reader.setContentHandler(ch);
                this.log("about to start parsing file='" + this.designFile + "'", 2);
                FileInputStream fileInput = new FileInputStream(this.designFile);
                InputSource src = new InputSource(fileInput);
                reader.parse(src);
                this.design = ch.getDesign();
                jar = new JarFile(this.jarFile);
                Enumeration<JarEntry> en = ((JarFile)jar).entries();
                while (en.hasMoreElements()) {
                    ZipEntry entry = en.nextElement();
                    if (!entry.getName().endsWith(".class")) continue;
                    InputStream in = ((JarFile)jar).getInputStream(entry);
                    this.verifyClassAdheresToDesign(this.design, in, entry.getName());
                }
                Object var10_12 = null;
            }
            catch (SAXException e) {
                this.deleteJarFile((JarFile)jar);
                if (e.getException() == null) throw new BuildException("Problem parsing design file='" + this.designFile + "'. Reason:\n" + e, e);
                if (!(e.getException() instanceof RuntimeException)) throw new BuildException("Problem parsing design file='" + this.designFile + "'. Reason:\n" + e, e);
                throw (RuntimeException)e.getException();
            }
            catch (IOException e) {
                this.deleteJarFile((JarFile)jar);
                throw new BuildException("IOException on design file='" + this.designFile + "'. attached:", e);
            }
            catch (RuntimeException e) {
                this.deleteJarFile((JarFile)jar);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                if (jar == null) throw throwable;
                jar.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (jar == null) return;
        jar.close();
        return;
    }

    private void deleteJarFile(JarFile jar) {
        try {
            if (jar != null) {
                jar.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.log("Deleting jar file=" + this.jarFile.getAbsolutePath() + " so you do not get tempted to use a jar that doesn't abide by the design", 2);
        boolean deleted = this.jarFile.delete();
        if (!deleted) {
            this.jarFile.deleteOnExit();
        }
    }

    private void verifyClassAdheresToDesign(Design d, InputStream in, String name) throws ClassFormatException, IOException {
        ClassParser parser = new ClassParser(in, name);
        JavaClass javaClass = parser.parse();
        this.className = javaClass.getClassName();
        d.setCurrentClass(this.className);
        ConstantPool pool = javaClass.getConstantPool();
        this.processConstantPool(pool);
        VisitorImpl visitor = new VisitorImpl(pool, this, d, this.task.getLocation());
        DescendingVisitor desc = new DescendingVisitor(javaClass, (Visitor)visitor);
        desc.visit();
    }

    private void processConstantPool(ConstantPool pool) {
        Constant[] constants = pool.getConstantPool();
        if (constants == null) {
            this.log("      constants=null", 3);
            return;
        }
        this.log("      constants len=" + constants.length, 3);
        for (int i = 0; i < constants.length; ++i) {
            this.processConstant(pool, constants[i], i);
        }
    }

    private void processConstant(ConstantPool pool, Constant c, int i) {
        if (c == null) {
            return;
        }
        this.log("      const[" + i + "]=" + pool.constantToString(c) + " inst=" + c.getClass().getName(), 4);
        byte tag = c.getTag();
        switch (tag) {
            case 7: {
                String firstLetter;
                int ind = ((ConstantClass)c).getNameIndex();
                c = pool.getConstant(ind, (byte)1);
                String className = Utility.compactClassName((String)((ConstantUtf8)c).getBytes(), (boolean)false);
                this.log("      classNamePre=" + className, 4);
                if (className.startsWith("[")) {
                    className = className.substring(1, className.length());
                }
                if (this.primitives.contains(firstLetter = className.charAt(0) + "")) {
                    return;
                }
                this.log("      className=" + className, 3);
                this.design.checkClass(className);
                break;
            }
        }
    }

    public static String getPackageName(String className) {
        String packageName = "<default package>";
        int index = className.lastIndexOf(".");
        if (index > 0) {
            packageName = className.substring(0, index);
        }
        return packageName;
    }

    public void log(String msg, int level) {
        this.task.log(msg, level);
    }
}

