/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.inifile;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import net.sf.antcontrib.inifile.IniFile;
import net.sf.antcontrib.inifile.IniProperty;
import net.sf.antcontrib.inifile.IniSection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class IniFileTask
extends Task {
    private File source;
    private File dest;
    private Vector operations = new Vector();

    public Set createSet() {
        Set set = new Set();
        this.operations.add(set);
        return set;
    }

    public Remove createRemove() {
        Remove remove = new Remove();
        this.operations.add(remove);
        return remove;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.dest == null) {
            throw new BuildException("You must supply a dest file to write to.");
        }
        IniFile iniFile = null;
        try {
            iniFile = this.readIniFile(this.source);
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
        Iterator it = ((AbstractList)this.operations).iterator();
        IniOperation operation = null;
        while (it.hasNext()) {
            operation = (IniOperation)it.next();
            operation.execute(this.getProject(), iniFile);
        }
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(this.dest);
                iniFile.write(writer);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IniFile readIniFile(File source) throws IOException {
        FileReader reader = null;
        IniFile iniFile = new IniFile();
        if (source == null) {
            return iniFile;
        }
        try {
            reader = new FileReader(source);
            iniFile.read(reader);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {}
        return iniFile;
    }

    public final class Set
    extends IniOperation {
        private String value;
        private String operation;

        public void setValue(String value) {
            this.value = value;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        protected void operate(IniFile file) {
            String secName = this.getSection();
            String propName = this.getProperty();
            IniSection section = file.getSection(secName);
            if (section == null) {
                section = new IniSection(secName);
                file.setSection(section);
            }
            if (propName != null) {
                if (this.operation != null) {
                    if ("+".equals(this.operation)) {
                        IniProperty prop = section.getProperty(propName);
                        this.value = prop.getValue();
                        int intVal = Integer.parseInt(this.value) + 1;
                        this.value = String.valueOf(intVal);
                    } else if ("-".equals(this.operation)) {
                        IniProperty prop = section.getProperty(propName);
                        this.value = prop.getValue();
                        int intVal = Integer.parseInt(this.value) - 1;
                        this.value = String.valueOf(intVal);
                    }
                }
                section.setProperty(new IniProperty(propName, this.value));
            }
        }
    }

    public static final class Remove
    extends IniOperation {
        protected void operate(IniFile file) {
            String secName = this.getSection();
            String propName = this.getProperty();
            if (propName == null) {
                file.removeSection(secName);
            } else {
                IniSection section = file.getSection(secName);
                if (section != null) {
                    section.removeProperty(propName);
                }
            }
        }
    }

    public static abstract class IniOperation {
        private String section;
        private String property;
        private String ifCond;
        private String unlessCond;

        public String getSection() {
            return this.section;
        }

        public void setSection(String section) {
            this.section = section;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void setIf(String ifCond) {
            this.ifCond = ifCond;
        }

        public void setUnless(String unlessCond) {
            this.unlessCond = unlessCond;
        }

        public boolean isActive(Project p) {
            if (this.ifCond != null && p.getProperty(this.ifCond) == null) {
                return false;
            }
            return this.unlessCond == null || p.getProperty(this.unlessCond) == null;
        }

        public void execute(Project project, IniFile iniFile) {
            if (this.isActive(project)) {
                this.operate(iniFile);
            }
        }

        protected abstract void operate(IniFile var1);
    }
}

