/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.util.Enumeration;
import java.util.Vector;
import net.sf.antcontrib.logic.condition.BooleanConditionTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class Assert
extends Task
implements TaskContainer {
    private boolean failOnError = true;
    private String execute = null;
    private boolean exists = true;
    private String value = null;
    private String name = null;
    private String message = "";
    private Task condition_task = null;
    private Vector tasks = new Vector();

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setMessage(String msg) {
        if (msg == null) {
            return;
        }
        this.message = msg;
    }

    public void setExists(String exists) {
        this.getProject();
        this.exists = Project.toBoolean(exists);
    }

    public void setExecute(String execute) {
        this.execute = execute;
    }

    public void setFailonerror(String fail) {
        this.failOnError = !(fail = fail.toLowerCase()).equals("false") && !fail.equals("off") && !fail.equals("no");
    }

    public void maybeConfigure() throws BuildException {
        if (this.isInvalid()) {
            super.maybeConfigure();
        } else {
            this.getRuntimeConfigurableWrapper().maybeConfigure(this.getProject(), false);
        }
    }

    public void addTask(Task task) {
        if (task instanceof BooleanConditionTask) {
            if (this.condition_task == null) {
                this.condition_task = task;
                return;
            }
            throw new BuildException("Only one <bool> allowed per If.");
        }
        this.tasks.addElement(task);
    }

    public void addBool(BooleanConditionTask boolTask) {
        this.addTask(boolTask);
    }

    public void execute() throws BuildException {
        block32: {
            block31: {
                String use_asserts = this.getProject().getProperty("ant.enable.asserts");
                if (use_asserts == null) break block31;
                this.getProject();
                if (Project.toBoolean(use_asserts)) break block32;
            }
            this.executeNestedTasks();
            return;
        }
        if (this.condition_task == null) {
            String msg;
            if (this.name == null || this.name.equals("")) {
                throw new BuildException("The 'name' attribute is required.");
            }
            String prop_value = this.getProject().getProperty(this.name);
            if (this.exists && prop_value == null) {
                msg = "Assertion failed: Property '" + this.name + "' doesn't exist in this project.\n" + this.message;
                if (this.failOnError) {
                    throw new BuildException(msg);
                }
                this.log(msg, 1);
            } else if (!this.exists && prop_value != null) {
                msg = "Assertion failed: Property '" + this.name + "' exists in this project, but shouldn't.\n" + this.message;
                if (this.failOnError) {
                    throw new BuildException(msg);
                }
                this.log(msg, 1);
            }
            if (this.value != null) {
                if (prop_value == null) {
                    msg = "Assertion failed: Expected '" + this.value + "', but was null\n" + this.message;
                    if (this.failOnError) {
                        throw new BuildException(msg);
                    }
                    this.log(msg, 1);
                } else if (prop_value != null) {
                    String b = prop_value.toLowerCase();
                    boolean have_boolean = false;
                    if (b.equals("on") || b.equals("yes") || b.equals("true") || b.equals("off") || b.equals("no") || b.equals("false")) {
                        have_boolean = true;
                    }
                    if (have_boolean) {
                        this.getProject();
                        boolean prop_bvalue = Project.toBoolean(prop_value);
                        this.getProject();
                        boolean bvalue = Project.toBoolean(this.value);
                        if (prop_bvalue != bvalue) {
                            String msg2 = "Assertion failed: Expected '" + bvalue + "', but was '" + prop_bvalue + "'.\n" + this.message;
                            if (this.failOnError) {
                                throw new BuildException(msg2);
                            }
                            this.log(msg2, 1);
                        }
                    } else if (!prop_value.equals(this.value)) {
                        String msg3 = "Assertion failed: Expected '" + this.value + "', but was '" + prop_value + "'.\n" + this.message;
                        if (this.failOnError) {
                            throw new BuildException(msg3);
                        }
                        this.log(msg3, 1);
                    }
                }
            }
        } else if (!((BooleanConditionTask)this.condition_task).eval()) {
            String msg = "Assertion failed boolean test.\n" + this.message;
            if (this.failOnError) {
                throw new BuildException(msg);
            }
            this.log(msg, 1);
        }
        boolean do_execute = true;
        if (this.execute == null) {
            this.execute = this.getProject().getProperty("assert.execute");
            if (this.execute != null) {
                this.getProject();
                do_execute = Project.toBoolean(this.execute);
            }
        } else {
            this.getProject();
            do_execute = Project.toBoolean(this.execute);
        }
        if (do_execute) {
            this.executeNestedTasks();
        }
    }

    private void executeNestedTasks() {
        Enumeration e = this.tasks.elements();
        while (e.hasMoreElements()) {
            Task task = (Task)e.nextElement();
            task.perform();
        }
    }

    public static int runTests() {
        Project p = new Project();
        Assert ass = new Assert();
        ass.setProject(p);
        String test_property = "test_property";
        String test_value = "test_value";
        p.setProperty("ant.enable.asserts", "true");
        int num_tests = 0;
        try {
            ass.execute();
            throw new RuntimeException("test 1 failed.");
        }
        catch (Exception e) {
            ++num_tests;
            try {
                ass.setName(test_property);
                ass.execute();
                throw new RuntimeException("test 2 test failed.");
            }
            catch (Exception e2) {
                ++num_tests;
                try {
                    p.setProperty(test_property, test_value);
                    ass.setName(test_property);
                    ass.execute();
                    ++num_tests;
                }
                catch (Exception e3) {
                    throw new RuntimeException("test 3 test failed:\n" + e3.getMessage());
                }
                try {
                    ass.setExists("false");
                    ass.execute();
                    throw new RuntimeException("test 4 failed");
                }
                catch (Exception e4) {
                    ++num_tests;
                    try {
                        ass.setExists("true");
                        ass.setValue(test_value);
                        ass.execute();
                        ++num_tests;
                    }
                    catch (Exception e5) {
                        throw new RuntimeException("test 5 failed\n" + e5.getMessage());
                    }
                    try {
                        ass.setValue("blah");
                        ass.execute();
                        throw new RuntimeException("test 6 failed");
                    }
                    catch (Exception e6) {
                        ++num_tests;
                        try {
                            ass.setExists("true");
                            p.setProperty("boolean prop", "true");
                            ass.setName("boolean prop");
                            ass.setValue("tRue");
                            ass.execute();
                            ++num_tests;
                            ass.setValue("on");
                            ass.execute();
                            ++num_tests;
                            ass.setValue("Yes");
                            ass.execute();
                            ++num_tests;
                        }
                        catch (Exception e7) {
                            throw new RuntimeException("test 7 failed\n" + e7.getMessage());
                        }
                        try {
                            ass.setValue("blah");
                            ass.setFailonerror("false");
                            ass.execute();
                            ++num_tests;
                        }
                        catch (Exception e8) {
                            throw new RuntimeException("test 10 failed");
                        }
                        try {
                            ass.setValue("blah");
                            ass.setFailonerror("true");
                            ass.execute();
                            throw new RuntimeException("test 11 failed");
                        }
                        catch (Exception e9) {
                            return ++num_tests;
                        }
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        int num_tests = Assert.runTests();
        System.out.println("Ran " + num_tests + " tests, all passed.");
    }
}

