/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.PageRenderer;

public abstract class AbstractTextPageRenderer
implements PageRenderer {
    public static final int PAGE_BLANK_LINES = 20;
    public static final int PAGE_DECO_WIDTH = 80;
    protected BufferedReader reader;
    protected PrintStream out;
    private InstallerContext ctx;
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    private static final char[] affimativeChars = AbstractTextPageRenderer.parseChars(res.getString("affirmativeChars"));

    public void setContext(InstallerContext ctx) {
        this.ctx = ctx;
    }

    public InstallerContext getContext() {
        return this.ctx;
    }

    public void init(BufferedReader reader, PrintStream out) {
        this.out = out;
        this.reader = reader;
    }

    public abstract boolean renderPage(Page var1) throws InstallException;

    protected void printHeader(Page page) throws IOException {
        int i;
        for (i = 0; i < 20; ++i) {
            this.out.println();
        }
        for (i = 0; i < 80; ++i) {
            this.out.print('~');
        }
        this.out.println();
        this.out.println("  " + page.getDisplayText());
        for (i = 0; i < 80; ++i) {
            this.out.print('~');
        }
        this.out.println();
        this.out.println();
        this.out.println();
    }

    private static char[] parseChars(String commaSeparated) {
        char[] input = commaSeparated.toCharArray();
        char[] theChars = new char[input.length];
        int j = 0;
        for (int i = 0; i < input.length; ++i) {
            if (Character.isWhitespace(input[i]) || ',' == input[i]) continue;
            theChars[j++] = input[i];
        }
        char[] toReturn = new char[j];
        System.arraycopy(theChars, 0, toReturn, 0, j);
        return toReturn;
    }

    protected boolean isTrue(String entered) {
        if (entered.length() == 0) {
            return true;
        }
        char first = entered.charAt(0);
        boolean isTrue = false;
        for (int i = 0; i < affimativeChars.length; ++i) {
            isTrue |= Character.toUpperCase(first) == affimativeChars[i];
        }
        return isTrue;
    }
}

