/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ResourceBundleHelper;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.ConditionalField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.text.SimpleInputPageRenderer;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;
import org.tp23.antinstaller.runtime.ConfigurationException;

public class ConditionalFieldRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundleHelper res = new ResourceBundleHelper("org.tp23.antinstaller.renderer.text.Res");
    private InstallerContext context;

    public void setContext(InstallerContext context) {
        this.context = context;
    }

    public void renderOutput(OutputField field, BufferedReader reader, PrintStream out) throws ValidationException, InstallException, IOException {
        ConditionalField conditional = (ConditionalField)field;
        try {
            OutputField[] fields = null;
            if (conditional.getExpression().evaluate()) {
                fields = conditional.getFields();
                SimpleInputPageRenderer.renderFields(this.context, fields, reader, out);
            }
        }
        catch (ConfigurationException configExc) {
            throw new InstallException(res.getMessage("invalid.conditional.expression", conditional.getIfProperty()), configExc);
        }
        catch (ClassNotFoundException clsNotFoundExc) {
            throw new InstallException(res.getMessage("text.render.not.found"), clsNotFoundExc);
        }
    }

    public void renderError(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
    }

    public boolean isAbort() {
        return false;
    }
}

