/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.AIRadioButton;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class SelectInputRenderer
extends SwingOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    protected SelectInput inputField;
    protected JLabel fieldLabel = new AILabel();
    protected ButtonGroup optionGroup = new ButtonGroup();

    public void initComponent(JPanel parent) {
        block2: {
            try {
                this.jbInit();
            }
            catch (Exception e) {
                this.ctx.log(e.getMessage());
                if (!this.ctx.getInstaller().isVerbose()) break block2;
                this.ctx.log(e);
            }
        }
    }

    public void setOutputField(OutputField inputField) {
        this.inputField = (SelectInput)inputField;
    }

    public void updateInputField() {
        Enumeration<AbstractButton> enumumeration = this.optionGroup.getElements();
        int i = 0;
        while (enumumeration.hasMoreElements()) {
            JRadioButton o = (JRadioButton)enumumeration.nextElement();
            if (o.isSelected()) {
                this.inputField.setValue(this.inputField.getOptions()[i].value);
                break;
            }
            ++i;
        }
        if (i > this.inputField.getOptions().length) {
            this.inputField.setValue(this.inputField.getDefaultValue());
        }
    }

    public void updateDefaultValue() {
        if (!this.inputField.isEditted()) {
            String newDefault = this.inputField.getDefaultValue();
            Enumeration<AbstractButton> enumeration = this.optionGroup.getElements();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                if (newDefault.equals(this.inputField.getOptions()[i].value)) {
                    JRadioButton jrb = (JRadioButton)enumeration.nextElement();
                    jrb.setSelected(true);
                } else {
                    enumeration.nextElement();
                }
                ++i;
            }
        }
    }

    private void jbInit() throws Exception {
        this.fieldLabel.setText(this.inputField.getDisplayText());
        SelectInput.Option[] options = this.inputField.getOptions();
        for (int i = 0; i < options.length; ++i) {
            AIRadioButton jrb = new AIRadioButton(options[i].getText());
            this.optionGroup.add(jrb);
            if (options[i].value.equals(this.inputField.getDefaultValue())) {
                jrb.setSelected(true);
            }
            jrb.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SelectInputRenderer.this.inputField.setEditted(true);
                }
            });
        }
    }

    public int addSelf(JPanel content, GBCF cf, int row, boolean overflow) {
        content.add((Component)this.fieldLabel, cf.getCell(row, 0));
        Enumeration<AbstractButton> enumeration = this.optionGroup.getElements();
        enumeration.hasMoreElements();
        AIRadioButton jrb = (AIRadioButton)enumeration.nextElement();
        content.add((Component)jrb, cf.getCell(row++, 1));
        if (overflow) {
            jrb.setOverflow(SizeConstants.OVERFLOW_FIELD_SIZE);
        }
        JPanel empty = new JPanel();
        while (enumeration.hasMoreElements()) {
            jrb = (AIRadioButton)enumeration.nextElement();
            content.add((Component)empty, cf.getCell(row, 0));
            content.add((Component)jrb, cf.getCell(row++, 1));
            if (!overflow) continue;
            jrb.setOverflow(SizeConstants.OVERFLOW_FIELD_SIZE);
        }
        return row;
    }

    public void renderError() {
        this.ctx.getMessageRenderer().printMessage(res.getString("notValidSelection"));
    }
}

