/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.FileInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class FileInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    protected InstallerContext ctx;

    public void setContext(InstallerContext ctx) {
        this.ctx = ctx;
    }

    public void renderOutput(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
        FileInput iField = (FileInput)field;
        out.print(iField.getDisplayText());
        out.print("   [");
        out.print(res.getString("_default_"));
        out.print(":");
        out.print(iField.getDefaultValue(true));
        out.print("]");
        out.println();
        String input = reader.readLine();
        out.println();
        if (input == null || input.equals("")) {
            input = iField.getDefaultValue(true);
        }
        iField.setInputResult(new File(input).getAbsolutePath());
    }

    public void renderError(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
        MessageRenderer mr = this.ctx.getMessageRenderer();
        mr.printMessage(res.getString("fileDoesNotExist"));
        this.renderOutput(field, reader, out);
    }

    public boolean isAbort() {
        return false;
    }
}

