/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.runtime.Logger;

public class SimpleLogger
implements Logger {
    BufferedWriter fos;
    private String fileName;

    public void setFileName(String fileName) {
        this.fileName = fileName;
        try {
            this.fos = new BufferedWriter(new FileWriter(fileName, false));
            this.fos.write("Logger initialized");
            this.fos.newLine();
        }
        catch (IOException e) {
            this.fos = null;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void log(String message) {
        if (this.fos == null) {
            return;
        }
        try {
            this.fos.write(message);
            this.fos.newLine();
            this.fos.flush();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can not write to logs");
        }
    }

    public void log(Installer installer, Throwable exception) {
        if (installer != null && installer.isVerbose()) {
            this.log(exception);
        }
    }

    public void log(Throwable exception) {
        if (this.fos == null) {
            return;
        }
        try {
            StringWriter writer = new StringWriter();
            exception.printStackTrace(new PrintWriter(writer));
            String s = writer.getBuffer().toString();
            this.fos.write(s);
            this.fos.newLine();
        }
        catch (IOException ex) {
            throw new RuntimeException("Can not write to logs");
        }
    }

    public void close() {
        try {
            if (this.fos != null) {
                this.fos.flush();
                this.fos.close();
                this.fos = null;
            }
        }
        catch (IOException e) {
            System.err.println("Can't close logger");
        }
    }

    protected void finalize() throws Throwable {
        if (this.fos != null) {
            this.fos.flush();
            this.fos.close();
        }
    }
}

