/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.selfextract;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ProgressIndicator
extends JFrame {
    public static final String IMAGE_RESOURCE = "/resources/extract-image.png";
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    private JPanel jPanel1 = new JPanel();
    private JProgressBar jProgressBar1 = new JProgressBar();
    private JLabel textLabel = new JLabel();
    private Border border1;
    private int max = 0;
    private static int PAGE_WIDTH = 160;
    private static int PAGE_HEIGHT = 110;
    private String title = res.getString("extracting");
    private JLabel imagePanel = new JLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private boolean useIcon = true;

    public ProgressIndicator(int max) {
        this.max = max;
        this.jbInit();
    }

    public ProgressIndicator(int max, String title) {
        this.max = max;
        this.title = title;
        this.jbInit();
    }

    private void setLocation() {
        GraphicsConfiguration config = this.getGraphicsConfiguration();
        int x = (int)config.getBounds().getCenterX() - PAGE_WIDTH / 2;
        int y = (int)config.getBounds().getCenterY() - PAGE_HEIGHT / 2;
        this.setLocation(x, y);
    }

    private void jbInit() {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jPanel1.setLayout(this.gridBagLayout1);
        int row = 0;
        this.getContentPane().add((Component)this.jPanel1, "Center");
        if (this.useIcon) {
            PAGE_HEIGHT = 110;
            this.setImage();
            this.jPanel1.add((Component)this.imagePanel, new GridBagConstraints(0, row++, 1, 1, 0.1, 0.9, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.setSize(new Dimension(PAGE_WIDTH, PAGE_HEIGHT));
        } else {
            PAGE_HEIGHT = 40;
            this.setSize(new Dimension(PAGE_WIDTH, 35));
        }
        this.jPanel1.setBorder(this.border1);
        this.jPanel1.setMaximumSize(new Dimension(PAGE_WIDTH, PAGE_HEIGHT));
        this.jPanel1.setMinimumSize(new Dimension(PAGE_WIDTH, PAGE_HEIGHT));
        this.jPanel1.setPreferredSize(new Dimension(PAGE_WIDTH, PAGE_HEIGHT));
        this.textLabel.setText(this.title);
        this.setTitle(this.title);
        this.jPanel1.add((Component)this.textLabel, new GridBagConstraints(0, row++, 1, 1, 0.1, 0.1, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jProgressBar1, new GridBagConstraints(0, row++, 1, 1, 0.1, 0.1, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jProgressBar1.setMinimum(0);
        this.jProgressBar1.setMaximum(this.max);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setSize(new Dimension(PAGE_WIDTH, PAGE_HEIGHT));
        this.setResizable(false);
        this.setUndecorated(true);
        this.setLocation();
    }

    public void tick() {
        this.jProgressBar1.setValue(this.jProgressBar1.getValue() + 1);
    }

    private void setImage() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream in = this.getClass().getResourceAsStream(IMAGE_RESOURCE);
            byte[] buffer = new byte[2048];
            int read = -1;
            while ((read = in.read(buffer)) != -1) {
                baos.write(buffer, 0, read);
            }
            ImageIcon icon = new ImageIcon(baos.toByteArray());
            this.imagePanel.setHorizontalAlignment(0);
            this.imagePanel.setIcon(icon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        try {
            ProgressIndicator indicator = null;
            indicator = new ProgressIndicator(200);
            indicator.show();
            UIManager.setLookAndFeel("org.tp23.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

