/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.tp23.antinstaller.input.CommentOutput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class CommentOutputRenderer
extends SwingOutputFieldRenderer {
    protected AILabel fieldLabel = new AILabel();
    protected JTextComponent explanatoryTextField;
    private static Font boldCommentFont = new JLabel().getFont();
    private static Font titleCommentFont;

    public void initComponent(JPanel parent) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOutputField(OutputField outputField) {
        this.outputField = (CommentOutput)outputField;
    }

    public void updateInputField() {
    }

    public JTextComponent getExplanatoryTextField() {
        return this.explanatoryTextField;
    }

    public void setExplanatoryTextField(JTextComponent explanatoryTextField) {
        this.explanatoryTextField = explanatoryTextField;
    }

    public void updateDefaultValue() {
        this.fieldLabel.setText(this.outputField.getDisplayText());
        if (this.explanatoryTextField != null) {
            this.explanatoryTextField.setText(this.outputField.getExplanatoryText());
        }
    }

    private void jbInit() throws Exception {
        CommentOutput cOutputField = (CommentOutput)this.outputField;
        this.fieldLabel.setText(cOutputField.getDisplayText());
        if (OutputField.isTrue(cOutputField.getBold())) {
            this.fieldLabel.setFont(boldCommentFont);
        }
        if (OutputField.isTrue(cOutputField.getTitle())) {
            this.fieldLabel.setFont(titleCommentFont);
        }
    }

    public int addSelf(JPanel content, GBCF cf, int row, boolean overflow) {
        content.add((Component)this.fieldLabel, cf.getSpan(row));
        if (overflow) {
            this.fieldLabel.setOverflow(SizeConstants.OVERFLOW_TOTAL_SIZE);
        } else {
            this.fieldLabel.setOverflow(new Dimension(SizeConstants.FIELD_WIDTH + SizeConstants.LABEL_WIDTH, SizeConstants.FIELD_HEIGHT));
        }
        return ++row;
    }

    public void renderError() {
    }

    static {
        try {
            boldCommentFont = new Font(boldCommentFont.getFamily(), 1, boldCommentFont.getSize());
            titleCommentFont = new Font(boldCommentFont.getFamily(), 1, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

